	   --------------------------------
       -- Fichier: ParamManager.vhd           
       -- Auteur: Christian Mercier                   
       -- Rvision: 3.0 ( Avril 2006 )                        
       --------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

ENTITY ParamManager IS
    PORT(

       CLK                       : IN    STD_LOGIC;
       RSTn                      : IN    STD_LOGIC;

	   ParamDAT_in               : IN    STD_LOGIC_VECTOR(31 downto 0);
	   ParamWrite_in             : IN    STD_LOGIC;

	   timestamp_in              : IN    STD_LOGIC_VECTOR(31 downto 0);

	   ParamDAT_out              : OUT   STD_LOGIC_VECTOR(31 downto 0);
	   PED_out                   : OUT   STD_LOGIC_VECTOR(15 downto 0);
	   HitdetThreshold_out       : OUT   STD_LOGIC_VECTOR(15 downto 0);
	   TriggerThreshold_out      : OUT   STD_LOGIC_VECTOR(15 downto 0);
	   CfdDelay_out              : OUT   STD_LOGIC_VECTOR(15 downto 0);
	   PRETRIG_out               : OUT   STD_LOGIC_VECTOR(15 downto 0);
	   SEGMENT_SIZE_out          : OUT   STD_LOGIC_VECTOR(15 downto 0);
	   K_out                     : OUT   STD_LOGIC_VECTOR(15 downto 0);
	   L_out                     : OUT   STD_LOGIC_VECTOR(15 downto 0);
	   M_out                     : OUT   STD_LOGIC_VECTOR(15 downto 0);
	   ATTENUATOR_out            : OUT   STD_LOGIC_VECTOR(15 downto 0);
	   SpareParam_out            : OUT   STD_LOGIC_VECTOR(15 downto 0);
	   ClipDelay_out             : OUT   STD_LOGIC_VECTOR(15 downto 0);
	   Mbits_out                 : OUT   STD_LOGIC_VECTOR(15 downto 0);
	   LATENCY_OUT               : OUT   STD_LOGIC_VECTOR(15 downto 0)
--	   testparam_out             : OUT   STD_LOGIC_VECTOR(15 downto 0)
     );
END ParamManager;

ARCHITECTURE a OF ParamManager IS
 
   TYPE states IS ( ATTENTE, PARAM_DATA);
   SIGNAL PARAM_STATE                   : states;

   SIGNAL PED                 : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL HitdetThreshold     : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL TriggerThreshold    : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL CfdDelay            : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL PRETRIG             : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL SEGMENT_SIZE        : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL K                   : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL L                   : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL M                   : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL ATTENUATOR          : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL SpareParam          : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL clipDelay           : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL Mbits               : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL LATENCY             : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL Timestamp_bits      : STD_LOGIC; -- which bits to send (upper=0/lower=1)
 --  SIGNAL testparam   : STD_LOGIC_VECTOR(15 downto 0);
  BEGIN

PED_out              <=  PED;
HitdetThreshold_out  <=  HitdetThreshold;
TriggerThreshold_out <=  TriggerThreshold;
CfdDelay_out         <=  CfdDelay;
PRETRIG_out          <=  PRETRIG;
SEGMENT_SIZE_out     <=  SEGMENT_SIZE;
K_out                <=  K;
M_out                <=  M;
L_out                <=  L;
ATTENUATOR_out       <=  ATTENUATOR;
SpareParam_out       <=  SpareParam;
ClipDelay_out        <=  ClipDelay;
Mbits_out            <=  Mbits;
LATENCY_OUT          <=  LATENCY;
-- testparam_out <= testparam;

PROCESS(RSTn, CLK)
BEGIN

IF RSTn = '0' THEN
 
--  DEFAULT VALUES---------------------------------
	PED                <= X"0000";
	HitdetThreshold    <= X"0140";  --  100
	TriggerThreshold   <= X"0082";  --  100
	CfdDelay           <= X"0028";  --   40
--	PRETRIG            <= X"0082";  --  130
	PRETRIG            <= X"0014";  --   20
	SEGMENT_SIZE       <= X"0020";  --  100
	K                  <= X"0190";  --  400
--	K                  <= X"0040";  --   64
	L                  <= X"0200";  --  512
--	L                  <= X"0069";  --  105
	M                  <= X"1000";  -- 4096
	ATTENUATOR         <= X"0190";  --  400
--	ATTENUATOR         <= X"007b";  --   64
	SpareParam         <= X"0000";  --   40
	ClipDelay          <= X"001e";  --   30
--	LATENCY            <= X"0078";  --  120
	LATENCY            <= X"00f0";  --  750 nsec
	Mbits              <= "0010000000010000"; --X"2010" 
	Timestamp_bits     <= '0';

ELSIF CLK'EVENT AND CLK = '1' THEN

	PED             <= PED;
	HitdetThreshold <= HitdetThreshold;
	CfdDelay        <= CfdDelay;
	PRETRIG         <= PRETRIG;
	SEGMENT_SIZE    <= SEGMENT_SIZE;
	K               <= K;
	M               <= M;
	L               <= L;
	ATTENUATOR      <= ATTENUATOR; -- 1/1000
	SpareParam      <= SpareParam;
	Mbits           <= Mbits;
	ClipDelay       <= ClipDelay;
	LATENCY         <= LATENCY;
    Timestamp_bits <= Timestamp_bits;

	IF ParamWrite_in = '1' THEN
       IF ParamDAT_in(7) = '0' THEN -- Testing the Readbit
  	     CASE ParamDAT_in(5 downto 0) IS
			WHEN "000001" => PED              <= ParamDAT_in(31 downto 16);		
			WHEN "000010" => HitdetThreshold  <= ParamDAT_in(31 downto 16);		
			WHEN "000011" => CfdDelay         <= ParamDAT_in(31 downto 16);
			WHEN "000100" => PRETRIG          <= ParamDAT_in(31 downto 16);	
			WHEN "000101" => SEGMENT_SIZE     <= ParamDAT_in(31 downto 16);
			WHEN "000110" => K                <= ParamDAT_in(31 downto 16);
			WHEN "000111" => L                <= ParamDAT_in(31 downto 16);
			WHEN "001000" => M                <= ParamDAT_in(31 downto 16);
			WHEN "001001" => SpareParam       <= ParamDAT_in(31 downto 16);
			WHEN "001010" => Mbits            <= ParamDAT_in(31 downto 16);
			WHEN "001011" => ClipDelay        <= ParamDAT_in(31 downto 16);
			WHEN "001100" => LATENCY	      <= ParamDAT_in(31 downto 16);
			WHEN "001101" => Timestamp_bits   <= '0';                       -- reset to upper bits
			WHEN "001110" => ATTENUATOR	      <= ParamDAT_in(31 downto 16);
			WHEN "001111" => TriggerThreshold <= ParamDAT_in(31 downto 16);		
			WHEN others =>
    	 END CASE;
	   END IF;
       ParamDAT_out(15 downto 0) <= ParamDAT_in(15 downto 0);
       CASE ParamDAT_in(5 downto 0) IS
  		  WHEN "000001" => ParamDAT_out(31 downto 16) <= PED;				-- X"01"
		  WHEN "000010" => ParamDAT_out(31 downto 16) <= HitdetThreshold;   -- 02
		  WHEN "000011" => ParamDAT_out(31 downto 16) <= CfdDelay;		    -- 03
		  WHEN "000100" => ParamDAT_out(31 downto 16) <= PRETRIG;			-- 04
		  WHEN "000101" => ParamDAT_out(31 downto 16) <= SEGMENT_SIZE;	    -- 05
		  WHEN "000110" => ParamDAT_out(31 downto 16) <= K;			        -- 06
		  WHEN "000111" => ParamDAT_out(31 downto 16) <= L;			        -- 07
		  WHEN "001000" => ParamDAT_out(31 downto 16) <= M;			     	-- 08
		  WHEN "001001" => ParamDAT_out(31 downto 16) <= SpareParam;        -- 09
		  WHEN "001010" => ParamDAT_out(31 downto 16) <= Mbits;		    	-- 0a
		  WHEN "001011" => ParamDAT_out(31 downto 16) <= ClipDelay;	        -- 0b
		  WHEN "001100" => ParamDAT_out(31 downto 16) <= LATENCY;			-- 0c
		  WHEN "001101" =>
		     IF Timestamp_bits = '1' THEN
                ParamDAT_out(31 downto 16) <= Timestamp_in(31 downto 16); -- upper 16 bits
                Timestamp_bits <= '0';
             ELSE
                ParamDAT_out(31 downto 16) <= Timestamp_in(15 downto 0);  -- lower 16 bits
             END IF;
		  WHEN "001110" => ParamDAT_out(31 downto 16) <= ATTENUATOR;		-- 0e
		  WHEN "001111" => ParamDAT_out(31 downto 16) <= TriggerThreshold;  -- 0F
		  WHEN others =>
       END CASE;
	END IF;
END IF;
END PROCESS;
END a;