	   ---------------------------------------------------
       -- Fichier: LVDSProtocolBuilder.vhd           
       -- Auteur: Christian Mercier                   
       -- Rvision: 1.0 ( Octobre 2004 )                        
       --                                   
       -- Description : It's the code for reading properlythe data from      
       --               the parameter fifo and recording it it a 4 bits fifo
       --
       -------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

ENTITY LVDSProtocolBuilder IS
    PORT(

       -- Dclaration de tous les signaux affectant         
       -- de l'extrieur 

       -- Signaux d'usage gnral
       clk                        : IN    STD_LOGIC;
       RSTn                       : IN    STD_LOGIC;

	   -- Line in contact with Serdes Cells
	   DataToSerdesT_out          : OUT    STD_LOGIC_VECTOR(7 downto 0);

       -- Real Time Line 4..0 : Real Time Line
       RealTimeLine_in            : IN    STD_LOGIC_VECTOR(4 downto 0);
	   TX_CRC_err_in              : IN    STD_LOGIC; -- reply to send from local decoder
	   TX_CRC_Stat_in             : IN    STD_LOGIC; --    just send out on link
	   RX_CRC_err_in              : IN    STD_LOGIC; -- reply received from remote decoder
	   RX_CRC_Stat_in             : IN    STD_LOGIC; --    use to decide if to resend data
	   CRC_ctrl_in                : IN    STD_LOGIC_VECTOR(1 downto 0); -- use to control encoding/waiting
       -- bit 0 controls sending encoded CRC status, bit 1 controls waiting to receive remote crc status

	   RegisterToLvds_in          : IN    STD_LOGIC_VECTOR(31 downto 0);
	   SpecialCodeToLvds_in       : IN    STD_LOGIC_VECTOR(7 downto 0);
	   Send_in                    : IN    STD_LOGIC;
	   Busy_out                   : OUT   STD_LOGIC

            
     );
END LVDSProtocolBuilder;

ARCHITECTURE a OF LVDSProtocolBuilder IS
 
   TYPE states IS ( ATTENTE, PARAM_BEGIN, PARAM_TRANSFER, PARAM_END);
   SIGNAL STATE                   : states;


   SIGNAL RealTimeToSerdesT	          : STD_LOGIC_VECTOR(4 downto 0);
   SIGNAL LastRealTimeToSerdesT	          : STD_LOGIC_VECTOR(4 downto 0);

   SIGNAL RegisterToLvds	      : STD_LOGIC_VECTOR(31 downto 0);
   SIGNAL SpecialCodeToLvds	      : STD_LOGIC_VECTOR(7 downto 0);
   SIGNAL TransferToSerdesTCnt    : STD_LOGIC_VECTOR(3 downto 0); -- Must count to at least 12
   SIGNAL CRCTimeoutCnt           : STD_LOGIC_VECTOR(5 downto 0); -- limit on waiting is 64
   SIGNAL CRCtoSerdesT            : STD_LOGIC_VECTOR(7 downto 0); 
   SIGNAL Busy      	          : STD_LOGIC; 

   CONSTANT Patron1              : STD_LOGIC_VECTOR(3 downto 0) := "1010";
   CONSTANT Patron2              : STD_LOGIC_VECTOR(3 downto 0) := "0110";


   
  BEGIN

-- TX CRC signals sent on every clock
-- RX stuff will come AFTER register sent
--    need to wait for reply after done sending

Busy_out <= Busy;

    ------------------------------------------------ 
    -- Processus principal grant le comportement des 
    -- tat du systme
    --                                               
    -----------------------------------------------  

PROCESS(RSTn, clk)
BEGIN

IF RSTn = '0' THEN

    
	RegisterToLvds <= "00000000000000000000000000000000";
	SpecialCodeToLvds <= "00000000";
	TransferToSerdesTCnt <= "0000";
	CRCTimeoutCnt <= "111111"; -- value irrelevant - will be set appropriately when required 
	CRCtoSerdesT <= "00000000";
	Busy <= '0';
	
ELSIF clk'EVENT AND clk = '1' THEN

	
	-- Input Buffering...
    RealTimeToSerdesT <= RealTimeLine_in;

    -- Keeping the last state of the RealTimeToSerdesT
    LastRealTimeToSerdesT <= RealTimeToSerdesT;
 
    -- DFF Creation...
	RegisterToLvds <= RegisterToLvds;
	SpecialCodeToLvds <= SpecialCodeToLvds;
	TransferToSerdesTCnt <= TransferToSerdesTCnt;
	CRCTimeoutCnt <= CRCTimeoutCnt;
	CRCtoSerdesT <= CRCtoSerdesT;
	Busy <= Busy;
	
	-- DataToSerdesT_out(1) <= Ack_in;
	IF CRC_ctrl_in(0) = '1' THEN -- Enable crc status encoding on bits 1,2
       DataToSerdesT_out(1) <= TX_CRC_err_in;
	   IF TX_CRC_Stat_in = '1' THEN
          DataToSerdesT_out(2) <= '0'; -- Parity Bit 0 => bit 1 contains Previous CRC result
       ELSE
          DataToSerdesT_out(2) <= '1'; -- Parity Bit Usually 1
	   END IF;
	   ELSE -- disable crc status encoding on bits 1,2 (go back to old scheme for these)
          DataToSerdesT_out(1) <= '0';
          DataToSerdesT_out(2) <= '1';
    END IF;
    -----------------------------------------------------
	-- Management of the output of a 32 bits register
	-- at the same time of the 5 real time lines
    -----------------------------------------------------

	-- If a change is detected in the RealTimeToSerdesT
	IF RealTimeToSerdesT(4 downto 0) /= LastRealTimeToSerdesT(4 downto 0) THEN

		DataToSerdesT_out(7 downto 3) <= RealTimeToSerdesT(4 downto 0);
        -- DataToSerdesT_out(2) <= '1'; -- Parity Bit Always 1
		DataToSerdesT_out(0) <= '1'; -- RealTime Change indicator ON			

		CRCtoSerdesT <= CRCtoSerdesT;

		 -- If a register is ready to be sent and we are not busy
	    IF Send_in = '1' AND Busy = '0' THEN
	        RegisterToLvds <= RegisterToLvds_in;
			SpecialCodeToLvds <= SpecialCodeToLvds_in;
			TransferToSerdesTCnt <= "0001";
		ELSE
		    TransferToSerdesTCnt <= TransferToSerdesTCnt;
	    END IF;
	 


	ELSE
  
      ----------------------------------------------------------
      -- Default assignment during the transfer of a register 
      ----------------------------------------------------------

	  -- We increment the TransferToSerdesTCnt except if it equals 0
      TransferToSerdesTCnt <= TransferToSerdesTCnt + 1;     	  

      -- Calculating of the CRC
   	  CRCtoSerdesT(2) <= CRCtoSerdesT(2) XOR '1';
   	  CRCtoSerdesT(1) <= CRCtoSerdesT(1) XOR '0';
   	  CRCtoSerdesT(0) <= CRCtoSerdesT(0) XOR '0';

      -- The realtime Indicator indicates no change
	  DataToSerdesT_out(0) <= '0'; 
	
	  -- The system is busy sending the register
      Busy <= '1';


	  CASE TransferToSerdesTCnt IS
	
	    -- If the counter equals '0', this indicates that there's no
	    -- transfer at the moment
		WHEN "0000" => 
		
		    -------------------------------------------------------------
		    -- SPECIAL STATE when no register must be send and no change 
		    -- occurs on the real time line
		    -------------------------------------------------------------
		
			DataToSerdesT_out(7 downto 3) <= "00000";
	        DataToSerdesT_out(0) <= '0'; -- RealTime Change indicator ON			
    		CRCtoSerdesT <= "00000000";
			Busy <= '0';
		
			-- If a register is ready to be sent and we are not busy
		    IF Send_in = '1' THEN
		        RegisterToLvds <= RegisterToLvds_in;
				SpecialCodeToLvds <= SpecialCodeToLvds_in;
				TransferToSerdesTCnt <= "0001";
			ELSE
			    TransferToSerdesTCnt <= TransferToSerdesTCnt;
		    END IF;
		 
		
		WHEN X"1" => DataToSerdesT_out(7 downto 4) <= SpecialCodeToLvds(3 downto 0);
					 DataToSerdesT_out(3) <= '1';  -- Indicating the start of register transfer
				     CRCtoSerdesT(7 downto 4) <= CRCtoSerdesT(7 downto 4) XOR SpecialCodeToLvds(3 downto 0);
				 	 CRCtoSerdesT(3) <= CRCtoSerdesT(3) XOR '1';
				
	    WHEN X"2" => DataToSerdesT_out(7 downto 4) <= SpecialCodeToLvds(7 downto 4);
				     DataToSerdesT_out(3) <= RegisterToLvds(24);
				     CRCtoSerdesT(7 downto 4) <= CRCtoSerdesT(7 downto 4) XOR SpecialCodeToLvds(7 downto 4);
				 	 CRCtoSerdesT(3) <= CRCtoSerdesT(3) XOR RegisterToLvds(24);
				
		WHEN X"3" => DataToSerdesT_out(7 downto 4) <= RegisterToLvds(3 downto 0);
				     DataToSerdesT_out(3) <= RegisterToLvds(25);
				     CRCtoSerdesT(7 downto 4) <= CRCtoSerdesT(7 downto 4) XOR RegisterToLvds(3 downto 0);
				 	 CRCtoSerdesT(3) <= CRCtoSerdesT(3) XOR RegisterToLvds(25);
				
		WHEN X"4" => DataToSerdesT_out(7 downto 4) <= RegisterToLvds(7 downto 4);
				     DataToSerdesT_out(3) <= RegisterToLvds(26);
				     CRCtoSerdesT(7 downto 4) <= CRCtoSerdesT(7 downto 4) XOR RegisterToLvds(7 downto 4);
				 	 CRCtoSerdesT(3) <= CRCtoSerdesT(3) XOR RegisterToLvds(26);
				
		WHEN X"5" => DataToSerdesT_out(7 downto 4) <= RegisterToLvds(11 downto 8);
				     DataToSerdesT_out(3) <= RegisterToLvds(27);
				     CRCtoSerdesT(7 downto 4) <= CRCtoSerdesT(7 downto 4) XOR RegisterToLvds(11 downto 8);
				 	 CRCtoSerdesT(3) <= CRCtoSerdesT(3) XOR RegisterToLvds(27);
				
		WHEN X"6" => DataToSerdesT_out(7 downto 4) <= RegisterToLvds(15 downto 12);
				     DataToSerdesT_out(3) <= RegisterToLvds(28);
				     CRCtoSerdesT(7 downto 4) <= CRCtoSerdesT(7 downto 4) XOR RegisterToLvds(15 downto 12);
				 	 CRCtoSerdesT(3) <= CRCtoSerdesT(3) XOR RegisterToLvds(28);
				
		WHEN X"7" => DataToSerdesT_out(7 downto 4) <= RegisterToLvds(19 downto 16);
				     DataToSerdesT_out(3) <= RegisterToLvds(29);
				     CRCtoSerdesT(7 downto 4) <= CRCtoSerdesT(7 downto 4) XOR RegisterToLvds(19 downto 16);
				 	 CRCtoSerdesT(3) <= CRCtoSerdesT(3) XOR RegisterToLvds(29);
				
		WHEN X"8" => DataToSerdesT_out(7 downto 4) <= RegisterToLvds(23 downto 20);
				     DataToSerdesT_out(3) <= RegisterToLvds(30);
				     CRCtoSerdesT(7 downto 4) <= CRCtoSerdesT(7 downto 4) XOR RegisterToLvds(23 downto 20);
				 	 CRCtoSerdesT(3) <= CRCtoSerdesT(3) XOR RegisterToLvds(30);
				
		WHEN X"9" => DataToSerdesT_out(7 downto 4) <= CRCtoSerdesT(7 downto 4);
				     DataToSerdesT_out(3) <= RegisterToLvds(31);
				 	 CRCtoSerdesT <= CRCtoSerdesT;
				     
		WHEN X"A" => DataToSerdesT_out(7 downto 4) <= CRCtoSerdesT(3 downto 0);
				     DataToSerdesT_out(3) <= '0'; -- Facultative data
					 -- Busy <= '0';
				     CRCTimeoutCnt <= "111111";

		WHEN X"B" => DataToSerdesT_out(7 downto 3) <= "00000";
	                 IF RX_CRC_Stat_in = '0' AND CRC_ctrl_in(1) = '1' AND CRCTimeoutCnt /= "000000" THEN
	                     TransferToSerdesTCnt <= TransferToSerdesTCnt; -- do not increment till receive crc
	                     CRCTimeoutCnt <= CRCTimeoutCnt - 1;
                     ELSE -- either crc was seen OR timeout counter expired (=> probably crc was suspect)
			     	    IF (RX_CRC_Err_in = '1' AND CRC_ctrl_in(1) = '1') OR CRCTimeoutCnt = "000000" THEN
                           -- CRC was bad, so resend current data ...
				           RegisterToLvds <= RegisterToLvds;
					   	   SpecialCodeToLvds <= SpecialCodeToLvds;
						   TransferToSerdesTCnt <= "0001";
						   CRCtoSerdesT <= "00000000";
				        ELSE
                           -- CRC was good, so continue ...
					       Busy <= '0';
					       -- We check if a data is immediatly ready and if there is one data, 
					       -- we will send it.
					       IF Send_in = '1' THEN
				              RegisterToLvds <= RegisterToLvds_in;
					   	      SpecialCodeToLvds <= SpecialCodeToLvds_in;
						      TransferToSerdesTCnt <= "0001";
						      CRCtoSerdesT <= "00000000";
					       ELSE
						      TransferToSerdesTCnt <= "0000";
						      CRCtoSerdesT <= "00000000";
				           END IF;
				        END IF;
				     END IF;
 
		WHEN others => DataToSerdesT_out(7 downto 4) <= "0000";
                     TransferToSerdesTCnt <= "0000";
	  END CASE; 
	END IF;
 
   ---------------------------------------------------------------------------------
   -- End of management

 
 
  
END IF;
END PROCESS;
END a;