	   ---------------------------------------------------
       -- Fichier: STB_Parameter.vhd           
       -- Auteur: Christian Mercier                   
       -- Rvision: 1.0 ( Octobre 2004 )                        
       --                                   
       -- Description : Interface with a VME Slave General Purpose bloc 
       --               to dispatch the data to the Parameter FIFO or 
       --               to the Event bloc
       --
       --               Functionnal with 16 bits and 32 bits VME Transfert
       -------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

ENTITY STB_Parameter IS
    PORT(

       -- Dclaration de tous les signaux affectant         
       -- de l'extrieur 

       -- Signaux d'usage gnral
       clk                        : IN    STD_LOGIC;
       RSTn                       : IN    STD_LOGIC;

       Loading_in                 : IN    STD_LOGIC;
	   AddressFromVME_in          : IN    STD_LOGIC_VECTOR(3 downto 0);
	   Data_in                    : IN    STD_LOGIC_VECTOR(15 downto 0);
	   par_read_in                : IN    STD_LOGIC;
	  
	   Disable_Mask_out           : OUT   STD_LOGIC_VECTOR(11 downto 0);
	   Required_Mask_out          : OUT   STD_LOGIC_VECTOR(11 downto 0);
	   Duration_out               : OUT   STD_LOGIC_VECTOR(11 downto 0);
	   Delay_out                  : OUT   STD_LOGIC_VECTOR(11 downto 0);
	   Selection_out              : OUT   STD_LOGIC_VECTOR(23 downto 0);
	   Multiplicity_out           : OUT   STD_LOGIC_VECTOR(3 downto 0);
	   Prescale_out               : OUT   STD_LOGIC_VECTOR(11 downto 0);
	   AlwaysActiveMask_out       : OUT   STD_LOGIC_VECTOR(11 downto 0);
	   VETObit_out                : OUT   STD_LOGIC;
       ParReadData_out            : OUT   STD_LOGIC_VECTOR(15 downto 0)
    
     );
END STB_Parameter;

ARCHITECTURE a OF STB_Parameter IS
 
   SIGNAL Loading                 : STD_LOGIC;
   SIGNAL par_read                : STD_LOGIC;
   --SIGNAL AddressFromVME          : STD_LOGIC_VECTOR(3 downto 0);

   SIGNAL Disable_Mask            : STD_LOGIC_VECTOR(11 downto 0);
   SIGNAL Required_Mask           : STD_LOGIC_VECTOR(11 downto 0);
   SIGNAL Duration                : STD_LOGIC_VECTOR(11 downto 0);
   SIGNAL Delay                   : STD_LOGIC_VECTOR(11 downto 0);
   SIGNAL Selection               : STD_LOGIC_VECTOR(23 downto 0);
   SIGNAL Multiplicity            : STD_LOGIC_VECTOR(3 downto 0);
   SIGNAL Prescale                : STD_LOGIC_VECTOR(11 downto 0);
   SIGNAL VETObit				  : STD_LOGIC;
   SIGNAL AlwaysActiveMask        : STD_LOGIC_VECTOR(11 downto 0);
   SIGNAL ParReadData             : STD_LOGIC_VECTOR(15 downto 0);

  BEGIN

Disable_Mask_out <= Disable_Mask;
Required_Mask_out <=  Required_Mask;
Duration_out <= Duration;
Delay_out <=  Delay;
Selection_out <= Selection;
Multiplicity_out <= Multiplicity;
Prescale_out <= Prescale;
VETObit_out  <= VETObit;
AlwaysActiveMask_out <= AlwaysActiveMask;
ParReadData_out <= ParReadData;
    ------------------------------------------------ 
    -- Processus principal grant le comportement des 
    -- tat du systme
    --                                               
    -----------------------------------------------  
PROCESS(RSTn, clk, AddressFromVME_in)
BEGIN

IF RSTn = '0' THEN

    --AddressFromVME    <= "0000";
    Loading           <= '0';

    Disable_Mask      <= X"000";
    Required_Mask     <= X"000";
    Duration          <= X"001"; -- here units of 40ns 
    Delay             <= X"000";
    Prescale          <= X"000";
    Selection         <= X"000000";
    Multiplicity      <= X"1";
    VETObit           <= '0';
    AlwaysActiveMask  <= x"000"; -- default set in all boxes - don't use 3ff or have to reprogram ALL to change!
    ParReadData       <= X"0000";
ELSIF clk'EVENT AND clk = '1' THEN

	-- Internal Buffer for Input
    --AddressFromVME <= AddressFromVME_in(3 downto 0); 

	-- Default Value for Output Buffer
	-- ** Originally used par_read_in directly, and loading_in via loading
	-- ** both 1 clock wide so the extra delay on loading caused the par_read to be missed
	-- unnecessary anyway - get rid of the delay + don't buffer either
    --Loading <= Loading_in;
    --par_read <= par_read_in;
    -- But now misses AddressFromVme!! so unbuffer this as well

    Disable_Mask <= Disable_Mask;
    Required_Mask <= Required_Mask;
    Duration <= Duration;
    Delay <= Delay;
    Prescale <= Prescale;
    Selection <= Selection;
    Multiplicity <= Multiplicity;
    VETObit      <= VETObit;
    AlwaysActiveMask  <= AlwaysActiveMask;
    ParReadData <= X"0000";

   IF Loading_in = '1' THEN
      IF par_read_in = '1' THEN
	     CASE AddressFromVME_in IS      
         WHEN  X"0" => ParReadData(15 downto 0) <= X"FFFF";
         WHEN  X"1" => ParReadData(15 downto 0) <= X"0"  & Duration;        	 
         WHEN  X"2" => ParReadData(15 downto 0) <= X"0"  &  Delay;
         WHEN  X"3" => ParReadData(15 downto 0) <= X"FFFF";
         WHEN  X"4" => ParReadData(15 downto 0) <= X"0"  &  Disable_Mask;
         WHEN  X"5" => ParReadData(15 downto 0) <= X"0"  &  Required_Mask;
         WHEN  X"6" => ParReadData(15 downto 0) <= X"000"&  Multiplicity;
         WHEN  X"7" => ParReadData(15 downto 0) <= X"0"  &  Prescale;
         WHEN  X"8" => ParReadData(15 downto 0) <= X"0"  &  Selection(11 downto 0);
         WHEN  X"9" => ParReadData(15 downto 0) <= X"0"  &  Selection(23 downto 12);
         WHEN  X"a" => ParReadData(15 downto 0) <= X"000" &  "000" & VETObit;
	     WHEN  X"b" => ParReadData(15 downto 0) <= X"0"  & AlwaysActiveMask;
	     WHEN OTHERS => ParReadData(15 downto 0) <= X"FFFF";
	     END CASE;
	  ELSE
	     CASE AddressFromVME_in IS      
         WHEN  X"0" => null;                -- Load STB ID...  
         WHEN  X"1" => Duration                <= Data_in(11 downto 0);        	 
         WHEN  X"2" => Delay                   <= Data_in(11 downto 0);
         WHEN  X"3" => null;                -- Reserved for a Deadtime parameter
         WHEN  X"4" => Disable_Mask            <= Data_in(11 downto 0);
         WHEN  X"5" => Required_Mask           <= Data_in(11 downto 0);
         WHEN  X"6" => Multiplicity            <= Data_in(3 downto 0);
         WHEN  X"7" => Prescale                <= Data_in(11 downto 0);
         WHEN  X"8" => Selection(11 downto 0)  <= Data_in(11 downto 0);
         WHEN  X"9" => Selection(23 downto 12) <= Data_in(11 downto 0);
         WHEN  X"a" => VETObit                 <= Data_in(0);
	     WHEN  X"b" => AlwaysActiveMask        <= Data_in(11 downto 0);
	     WHEN OTHERS => null;
	     END CASE;
	  END IF; -- par-read
   END IF;    -- loading
END IF;
END PROCESS;
END a;