	   ---------------------------------------------------
       -- Fichier: ParameterCenter.vhd           
       -- Auteur: Christian Mercier                   
       -- Rvision: 1.0 ( Octobre 2004 )                        
       --                                   
       -- Modified so local parameter handling elsewhere
       -- Parameter read requests are handled there, and response                
       -- passed to here, only 16bit parameters 
       --                                                     
       -------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

ENTITY ParameterCenter IS
    PORT(
       clk                        : IN    STD_LOGIC;
       RSTn                       : IN    STD_LOGIC;

	   LocalParam                 : IN    STD_LOGIC_VECTOR(7 downto 4);
	   SC4_Register               : IN    STD_LOGIC_VECTOR(31 downto 0);
	   SC6_Register               : IN    STD_LOGIC_VECTOR(31 downto 0);
	   SC7_Register               : IN    STD_LOGIC_VECTOR(31 downto 0);
	  
	   SpecialCode_out            : OUT   STD_LOGIC_VECTOR(7 downto 0);
	   Register_out               : OUT   STD_LOGIC_VECTOR(31 downto 0);
       Ready_out                  : OUT   STD_LOGIC;

       CrcControl_out             : OUT   STD_LOGIC_VECTOR(31 downto 0);
       timestamp                  : IN    STD_LOGIC_VECTOR(31 downto 0);
       SerFlash_out               : OUT   STD_LOGIC_VECTOR(15 downto 0);
       SerFlash_in                : IN    STD_LOGIC_VECTOR(15 downto 0);

	   TrigPar_in                 : IN    STD_LOGIC_VECTOR(31 downto 0);
	   TrigResponse_in            : IN    STD_LOGIC;
	   TrigPar_out                : OUT   STD_LOGIC_VECTOR(31 downto 0);
	   TrigPar_active_out         : OUT   STD_LOGIC
     );
END ParameterCenter;

ARCHITECTURE a OF ParameterCenter IS

   SIGNAL Param16bits               : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL Param32bits               : STD_LOGIC_VECTOR(31 downto 0);
   
   SIGNAL OUTPUT_Register           : STD_LOGIC_VECTOR(31 downto 0);
   SIGNAL OUTPUT_SpecialCode        : STD_LOGIC_VECTOR(7 downto 0);
   SIGNAL OUTPUT_Ready              : STD_LOGIC;

   SIGNAL CrcControl                : STD_LOGIC_VECTOR(31 downto 0);
   SIGNAL TrigPar                   : STD_LOGIC_VECTOR(31 downto 0);
   SIGNAL TrigPar_active            : STD_LOGIC;

  BEGIN

Register_out       <= OUTPUT_Register;
SpecialCode_out    <= OUTPUT_SpecialCode;
Ready_out          <= OUTPUT_Ready;
CrcControl_out     <= CrcControl;
TrigPar_out        <= TrigPar;
TrigPar_active_out <= TrigPar_active;

PROCESS(RSTn, clk)
BEGIN

IF RSTn = '0' THEN

     Param16bits        <= X"0000";
     Param32bits        <= X"00000000";

     OUTPUT_SpecialCode <= X"00";
     OUTPUT_Register    <= X"00000000";
     OUTPUT_Ready       <= '0';

     CrcControl         <=  X"00000000"; -- default is no crc
     TrigPar            <=  X"00000000";
     TrigPar_active     <= '0';

ELSIF clk'EVENT AND clk = '1' THEN

     Param16bits        <= Param16bits;
     Param32bits        <= Param32bits;
	 OUTPUT_Register    <= OUTPUT_Register;     -- unless response keep current values
     OUTPUT_SpecialCode <= OUTPUT_SpecialCode;
     OUTPUT_Ready       <= '0';
     CrcControl         <=  CrcControl;
     TrigPar            <=  TrigPar;
     TrigPar_active     <= '0';

     IF localparam(4) = '1' THEN 
        if SC4_Register(7) = '0' THEN -- write parameter (pass out to trigger if unrecognised)
	       CASE SC4_Register(3 downto 0) IS      
           WHEN  X"D"  => SerFlash_out(15 downto  0) <= SC4_Register(31 downto 16);
           WHEN  X"E"  =>   CrcControl(15 downto  0) <= SC4_Register(31 downto 16);
           WHEN  X"F"  =>   CrcControl(31 downto 16) <= SC4_Register(31 downto 16);
	       WHEN OTHERS => TrigPar                  <= SC4_Register;
	                      TrigPar_active           <= '1';
	       END CASE;
        ELSE                         -- read             (pass out to trigger if unrecognised)
	       CASE SC4_Register(3 downto 0) IS      
           --WHEN  X"E"  => OUTPUT_Register(31 downto 16) <= CrcControl(15 downto  0);
           --               OUTPUT_SpecialCode            <= X"04";
           --               OUTPUT_Ready                  <= '1';
           --WHEN  X"F"  => OUTPUT_Register(31 downto 16) <= CrcControl(31 downto 16);
           --               OUTPUT_SpecialCode            <= X"04";
           --               OUTPUT_Ready                  <= '1';
           WHEN  X"D"  => OUTPUT_Register(31 downto 16) <= SerFlash_in(15 downto  0);
                          OUTPUT_SpecialCode            <= X"04";
                          OUTPUT_Ready                  <= '1';
           WHEN  X"E"  => OUTPUT_Register(31 downto 16) <= timestamp(15 downto  0);
                          OUTPUT_SpecialCode            <= X"04";
                          OUTPUT_Ready                  <= '1';
           WHEN  X"F"  => OUTPUT_Register(31 downto 16) <= timestamp(31 downto 16);
                          OUTPUT_SpecialCode            <= X"04";
                          OUTPUT_Ready                  <= '1';
	       WHEN OTHERS => TrigPar                       <= SC4_Register;
	                      TrigPar_active                <= '1';
	       END CASE;
        END IF;
     END IF;
     IF TrigResponse_in = '1' THEN
         -- If this comes at same time as new request for crc, this will overwrite that reply
         -- BUT a new request should not come before the previous response is received
	     OUTPUT_SpecialCode           <= X"04";
		 OUTPUT_Ready                 <= '1';
         OUTPUT_Register(31 downto 0) <= TrigPar_in(31 downto 0); 
     END IF;

END IF;
END PROCESS;
END a;