	   ---------------------------------------------------
       -- Fichier: ParameterCenter.vhd           
       -- Auteur: Christian Mercier                   
       -- Rvision: 1.0 ( Octobre 2004 )                        
       --                                   
       -- Description : This code fill up a FIFO of data of 4 bits with      
       --               a 16 bits register
       --
       --               Functionnal with 16 bits and 32 bits VME Transfert
       -------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

ENTITY ParameterCenter IS
    PORT(

       -- Dclaration de tous les signaux affectant         
       -- de l'extrieur 

       -- Signaux d'usage gnral
       clk                        : IN    STD_LOGIC;
       RSTn                       : IN    STD_LOGIC;

	   LocalParam                 : IN    STD_LOGIC_VECTOR(7 downto 4);
	   SC4_Register               : IN    STD_LOGIC_VECTOR(31 downto 0);
	   SC6_Register               : IN    STD_LOGIC_VECTOR(31 downto 0);
	   SC7_Register               : IN    STD_LOGIC_VECTOR(31 downto 0);
	  
	   FirmwareID_out             : OUT   STD_LOGIC_VECTOR(15 downto 0);

	   SpecialCode_out            : OUT   STD_LOGIC_VECTOR(7 downto 0);
	   Register_out               : OUT   STD_LOGIC_VECTOR(31 downto 0);
       Ready_out                  : OUT   STD_LOGIC

            
     );
END ParameterCenter;

ARCHITECTURE a OF ParameterCenter IS

   -- Parameter DFF 
   SIGNAL FirmwareID                : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL Param16bits               : STD_LOGIC_VECTOR(15 downto 0);
   SIGNAL Param32bits               : STD_LOGIC_VECTOR(31 downto 0);
   
   SIGNAL OUTPUT_Register           : STD_LOGIC_VECTOR(31 downto 0);
   SIGNAL OUTPUT_SpecialCode        : STD_LOGIC_VECTOR(7 downto 0);
   SIGNAL OUTPUT_Ready              : STD_LOGIC;
   
  BEGIN


Register_out <= OUTPUT_Register;
FirmwareID_out <= FirmwareID;
SpecialCode_out <= OUTPUT_SpecialCode;
Ready_out <= OUTPUT_Ready;
    ------------------------------------------------ 
    -- Processus principal grant le comportement des 
    -- tat du systme
    --                                               
    -----------------------------------------------  
PROCESS(RSTn, clk)
BEGIN

IF RSTn = '0' THEN

     FirmwareID <= X"0211";
     Param16bits <= "0000000000000000";
     Param32bits <= "00000000000000000000000000000000";

     OUTPUT_SpecialCode <= "00000000";
     OUTPUT_Register <= "00000000000000000000000000000000";
     OUTPUT_Ready <= '0';

ELSIF clk'EVENT AND clk = '1' THEN

     FirmwareID <= FirmwareID;
     Param16bits <= Param16bits;
     Param32bits <= Param32bits;
	 OUTPUT_Register <=  OUTPUT_Register;
     OUTPUT_SpecialCode <= OUTPUT_SpecialCode;
     OUTPUT_Ready <= '0';

     --------------------------------
     -- Transfer of 16 bits Parameter
     --------------------------------
	 IF LocalParam(4) = '1' THEN
		
		-- Checking if the parameter is read 
		IF SC4_Register(7) = '1' THEN
		
		    OUTPUT_Register(15 downto 0) <= SC4_Register(15 downto 0);
		    OUTPUT_SpecialCode <= "00000100";
--		    OUTPUT_Ready <= '1';
			OUTPUT_Ready <= '0';
	
		    -- The parameter is read
		    CASE SC4_Register(3 downto 0) IS
		      WHEN "1101" =>  OUTPUT_Register(31 downto 16) <= FirmwareID; 
		      WHEN "1111" =>  OUTPUT_Register(31 downto 16) <= Param16bits; 
		      WHEN others =>  OUTPUT_Register(31 downto 16) <= "0000000000000000"; 
		                      OUTPUT_Register(7) <= '0';
			END CASE;
			
    	ELSE

		    -- The parameter is recorded
		    CASE SC4_Register(3 downto 0) IS
--		      WHEN "111" =>  FirmwareID <= SC4_Register(31 downto 16);
		      WHEN "1111" =>  Param16bits <= SC4_Register(31 downto 16);
		      WHEN others =>  
		                      
			END CASE;

		END IF;		
	 END IF;
	
	
	
END IF;
END PROCESS;
END a;