	   ---------------------------------------------------
       -- Fichier: DistributionPortID.vhd           
       -- Auteur: Christian Mercier                   
       -- Rvision: 1.0 ( Octobre 2004 )                        
       --                                   
       -- Description : This code fill up a FIFO of data of 4 bits with      
       --               a 16 bits register
       --
       --               Functionnal with 16 bits and 32 bits VME Transfert
       -------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;

ENTITY DistributionPortID IS
    PORT(

       -- Dclaration de tous les signaux affectant         
       -- de l'extrieur 

       -- Signaux d'usage gnral
       clk                        : IN    STD_LOGIC;
       RSTn                       : IN    STD_LOGIC;

	   PortID_in                  : IN    STD_LOGIC_VECTOR(3 downto 0);
       Signal_in                  : IN    STD_LOGIC;
	   Busy_in                    : IN    STD_LOGIC_VECTOR(10 downto 1);
	  
	   Signal_out                 : OUT   STD_LOGIC_VECTOR(10 downto 1);
       Local_out                  : OUT   STD_LOGIC;
       Busy_out                   : OUT   STD_LOGIC
            
     );
END DistributionPortID;

ARCHITECTURE a OF DistributionPortID IS
 
   SIGNAL Signal_DFF              : STD_LOGIC_VECTOR(10 downto 1);
   SIGNAL Local_DFF              : STD_LOGIC;
   SIGNAL Signal_IN_DFF              : STD_LOGIC;
   
   
  BEGIN


Signal_out <= Signal_DFF;
Local_out <= Local_DFF;

    ------------------------------------------------ 
    -- Processus principal grant le comportement des 
    -- tat du systme
    --                                               
    -----------------------------------------------  
PROCESS(RSTn, clk)
BEGIN

IF RSTn = '0' THEN

     Signal_DFF <= "0000000000";
     Local_DFF <= '0';
     Signal_IN_DFF <= '0';
     Busy_out <= '1';

ELSIF clk'EVENT AND clk = '1' THEN

     Signal_DFF <= "0000000000";
     Local_DFF <= '0';
     Signal_IN_DFF <= Signal_in;
     Busy_out <= '1';

    CASE PortID_in IS
  
    WHEN "0000" => Signal_DFF(1) <= Signal_IN_DFF; 
			       Busy_out <= Busy_in(1);
    WHEN "0001" => Signal_DFF(2) <= Signal_IN_DFF; 
			       Busy_out <= Busy_in(2);
    WHEN "0010" => Signal_DFF(3) <= Signal_IN_DFF; 
			       Busy_out <= Busy_in(3);
    WHEN "0011" => Signal_DFF(4) <= Signal_IN_DFF; 
			       Busy_out <= Busy_in(4);
    WHEN "0100" => Signal_DFF(5) <= Signal_IN_DFF; 
			       Busy_out <= Busy_in(5);
    WHEN "0101" => Signal_DFF(6) <= Signal_IN_DFF;
			       Busy_out <= Busy_in(6);
    WHEN "0110" => Signal_DFF(7) <= Signal_IN_DFF;
			       Busy_out <= Busy_in(7);
    WHEN "0111" => Signal_DFF(8) <= Signal_IN_DFF; 
			       Busy_out <= Busy_in(8);
    WHEN "1000" => Signal_DFF(9) <= Signal_IN_DFF; 
			       Busy_out <= Busy_in(9);
    WHEN "1001" => Signal_DFF(10 ) <= Signal_IN_DFF;
			       Busy_out <= Busy_in(10);
    WHEN "1110" => Local_DFF <= Signal_IN_DFF;
    WHEN "1111" => 
		Signal_DFF(1) <= Signal_IN_DFF; 
		Signal_DFF(2) <= Signal_IN_DFF; 
		Signal_DFF(3) <= Signal_IN_DFF; 
		Signal_DFF(4) <= Signal_IN_DFF; 
		Signal_DFF(5) <= Signal_IN_DFF; 
		Signal_DFF(6) <= Signal_IN_DFF; 
		Signal_DFF(7) <= Signal_IN_DFF; 
		Signal_DFF(8) <= Signal_IN_DFF; 
		Signal_DFF(9) <= Signal_IN_DFF; 
		Signal_DFF(10) <= Signal_IN_DFF; 

    WHEN others => 

    END CASE;

END IF;
END PROCESS;
END a;