-- WARNING: Do NOT edit the input and output ports in this file in a text
-- editor if you plan to continue editing the block that represents it in
-- the Block Editor! File corruption is VERY likely to occur.

-- Copyright (C) 1991-2004 Altera Corporation
-- Any  megafunction  design,  and related netlist (encrypted  or  decrypted),
-- support information,  device programming or simulation file,  and any other
-- associated  documentation or information  provided by  Altera  or a partner
-- under  Altera's   Megafunction   Partnership   Program  may  be  used  only
-- to program  PLD  devices (but not masked  PLD  devices) from  Altera.   Any
-- other  use  of such  megafunction  design,  netlist,  support  information,
-- device programming or simulation file,  or any other  related documentation
-- or information  is prohibited  for  any  other purpose,  including, but not
-- limited to  modification,  reverse engineering,  de-compiling, or use  with
-- any other  silicon devices,  unless such use is  explicitly  licensed under
-- a separate agreement with  Altera  or a megafunction partner.  Title to the
-- intellectual property,  including patents,  copyrights,  trademarks,  trade
-- secrets,  or maskworks,  embodied in any such megafunction design, netlist,
-- support  information,  device programming or simulation file,  or any other
-- related documentation or information provided by  Altera  or a megafunction
-- partner, remains with Altera, the megafunction partner, or their respective
-- licensors. No other licenses, including any licenses needed under any third
-- party's intellectual property, are provided herein.


-- Generated by Quartus II Version 4.0 (Build Build 214 3/25/2004)
-- Created on Thu Jul 22 01:32:26 2004

LIBRARY ieee;
USE ieee.std_logic_1164.all;


--  Entity Declaration

ENTITY EVMPX IS
	-- {{ALTERA_IO_BEGIN}} DO NOT REMOVE THIS LINE!
	PORT
	(
		CLK 		: IN STD_LOGIC;
		RESET 		: IN STD_LOGIC;
		EMPTY1 		: IN STD_LOGIC;
		EMPTY2 		: IN STD_LOGIC;
		EMPTY3 		: IN STD_LOGIC;
		EMPTY4 		: IN STD_LOGIC;
		EMPTY5 		: IN STD_LOGIC;
		EMPTY6 		: IN STD_LOGIC;
		EVA 		: IN STD_LOGIC_VECTOR(31 downto 0);
		EVB 		: IN STD_LOGIC_VECTOR(31 downto 0);
		EVC 		: IN STD_LOGIC_VECTOR(31 downto 0);
		EVD 		: IN STD_LOGIC_VECTOR(31 downto 0);
		EVE 		: IN STD_LOGIC_VECTOR(31 downto 0);
		EVF 		: IN STD_LOGIC_VECTOR(31 downto 0);
		EVOUT 		: OUT STD_LOGIC_VECTOR(31 downto 0);
		ACKFIFO1	: OUT STD_LOGIC;
		ACKFIFO2	: OUT STD_LOGIC;
		ACKFIFO3	: OUT STD_LOGIC;
		ACKFIFO4	: OUT STD_LOGIC;
		ACKFIFO5	: OUT STD_LOGIC;
		ACKFIFO6	: OUT STD_LOGIC;
		STROBEOUT 	: OUT STD_LOGIC
	);
	-- {{ALTERA_IO_END}} DO NOT REMOVE THIS LINE!
	
END EVMPX;


--  Architecture Body

ARCHITECTURE EVMPX_architecture OF EVMPX IS
--  Define one state for each of the 6 links
	TYPE states IS (IDLE,A,B,C,D,E,F);
	SIGNAL STATE			: states;
	SIGNAL TimeOutCounter	: STD_LOGIC_VECTOR(3 downto 0);
	SIGNAL TIMEOUT			: STD_LOGIC;
	SIGNAL HeaderDetected	: STD_LOGIC;


BEGIN
	
--  Sequencer process
	PROCESS(RESET,CLK)
		VARIABLE HeaderCode	: STD_LOGIC_VECTOR(3 downto 0);

	BEGIN
		IF  RESET = '1' THEN
			STATE						<= IDLE;
			TimeOutCounter 				<= X"0";
			HeaderDetected				<= '0';
			TIMEOUT						<= '0';
		ELSIF CLK'EVENT AND CLK = '1' THEN
			CASE STATE IS
			WHEN IDLE =>
				STATE					<=A;
--         ***********************************************************8
			WHEN A	=>
				IF EMPTY1 = '0' AND EVA(31 downto 28) = X"8" THEN
					HeaderDetected		<= '1';
					STATE				<= A;
				ELSIF EMPTY1 = '0' AND HeaderDetected = '1' THEN
					IF EVA(31 downto 28) = X"E" THEN
					-- This is the trailer
						HeaderDetected	<= '0';
						STATE			<= B;
					ELSE
						STATE			<= A;
					END IF;
				ELSIF EMPTY1 = '1' AND HeaderDetected = '1' THEN
				-- Wait for new frame to come
					IF TIMEOUT = '1' THEN
					-- Abnormal situation (do what?)
						HeaderDetected	<= '0';
						STATE			<= B;
					ELSE
						STATE			<= A;
					END IF;
				ELSE
					HeaderDetected		<= '0';
					STATE				<= B;
				END IF;
--         ***********************************************************8
			WHEN B	=>
				IF EMPTY2 = '0' AND EVB(31 downto 28) = X"8" THEN
					HeaderDetected		<= '1';
					STATE				<= B;
				ELSIF EMPTY2 = '0' AND HeaderDetected = '1' THEN
					IF EVB(31 downto 28) = X"E" THEN
					-- This is the trailer
						HeaderDetected	<= '0';
						STATE			<= C;
					ELSE
						STATE			<= B;
					END IF;
				ELSIF EMPTY2 = '1' AND HeaderDetected = '1' THEN
				-- Wait for new frame to come
					IF TIMEOUT = '1' THEN
					-- Abnormal situation (do what?)
						HeaderDetected	<= '0';
						STATE			<= C;
					ELSE
						STATE			<= B;
					END IF;
				ELSE
					HeaderDetected	<= '0';
					STATE				<= C;
				END IF;
--         ***********************************************************8
			WHEN C	=>
				IF EMPTY3 = '0' AND EVC(31 downto 28) = X"8" THEN
					HeaderDetected		<= '1';
					STATE				<= C;
				ELSIF EMPTY3 = '0' AND HeaderDetected = '1' THEN
					IF EVC(31 downto 28) = X"E" THEN
					-- This is the trailer
						HeaderDetected	<= '0';
						STATE			<= D;
					ELSE
						STATE			<= C;
					END IF;
				ELSIF EMPTY3 = '1' AND HeaderDetected = '1' THEN
				-- Wait for new frame to come
					IF TIMEOUT = '1' THEN
					-- Abnormal situation (do what?)
						HeaderDetected	<= '0';
						STATE			<= D;
					ELSE
						STATE			<= C;
					END IF;
				ELSE
					HeaderDetected		<= '0';
					STATE				<= D;
				END IF;
--         ***********************************************************8
			WHEN D	=>
				IF EMPTY4 = '0' AND EVD(31 downto 28) = X"8" THEN
					HeaderDetected		<= '1';
					STATE				<= D;
				ELSIF EMPTY4 = '0' AND HeaderDetected = '1' THEN
					IF EVD(31 downto 28) = X"E" THEN
					-- This is the trailer
						HeaderDetected	<= '0';
						STATE			<= E;
					ELSE
						STATE			<= D;
					END IF;
				ELSIF EMPTY4 = '1' AND HeaderDetected = '1' THEN
				-- Wait for new frame to come
					IF TIMEOUT = '1' THEN
					-- Abnormal situation (do what?)
						HeaderDetected	<= '0';
						STATE			<= E;
					ELSE
						STATE			<= D;
					END IF;
				ELSE
					HeaderDetected		<= '0';
					STATE				<= E;
				END IF;
--         ***********************************************************8
			WHEN E	=>
				IF EMPTY5 = '0' AND EVE(31 downto 28) = X"8" THEN
					HeaderDetected		<= '1';
					STATE				<= E;
				ELSIF EMPTY5 = '0' AND HeaderDetected = '1' THEN
					IF EVE(31 downto 28) = X"E" THEN
					-- This is the trailer
						HeaderDetected	<= '0';
						STATE			<= F;
					ELSE
						STATE			<= E;
					END IF;
				ELSIF EMPTY5 = '1' AND HeaderDetected = '1' THEN
				-- Wait for new frame to come
					IF TIMEOUT = '1' THEN
					-- Abnormal situation (do what?)
						HeaderDetected	<= '0';
						STATE			<= F;
					ELSE
						STATE			<= E;
					END IF;
				ELSE
					HeaderDetected		<= '0';
					STATE				<= F;
				END IF;
--         ***********************************************************8
			WHEN F	=>
				IF EMPTY6 = '0' AND EVF(31 downto 28) = X"8" THEN
					HeaderDetected		<= '1';
					STATE				<= F;
				ELSIF EMPTY6 = '0' AND HeaderDetected = '1' THEN
					IF EVF(31 downto 28) = X"E" THEN
					-- This is the trailer
						HeaderDetected	<= '0';
						STATE			<= IDLE;
					ELSE
						STATE			<= F;
					END IF;
				ELSIF EMPTY6 = '1' AND HeaderDetected = '1' THEN
				-- Wait for new frame to come
					IF TIMEOUT = '1' THEN
					-- Abnormal situation (do what?)
						HeaderDetected	<= '0';
						STATE			<= IDLE;
					ELSE
						STATE			<= F;
					END IF;
				ELSE
					HeaderDetected		<= '0';
					STATE				<= IDLE;
				END IF;
				
			END CASE;
		END IF;
	END PROCESS;
--
	PROCESS (RESET,STATE)
	BEGIN
		IF RESET = '1' THEN
			STROBEOUT					<= '0';
			ACKFIFO1					<='0';
			ACKFIFO2					<='0';
			ACKFIFO3					<='0';
			ACKFIFO4					<='0';
			ACKFIFO5					<='0';
			ACKFIFO6					<='0';
		END IF;
		CASE STATE IS
			WHEN A =>
					EVOUT				<= EVA;
					STROBEOUT			<= NOT EMPTY1;
					ACKFIFO6			<= '0';
					ACKFIFO1			<= NOT EMPTY1;
			WHEN B =>
					EVOUT				<= EVB;
					STROBEOUT			<= NOT EMPTY2;
					ACKFIFO1			<= '0';
					ACKFIFO2			<= NOT EMPTY2;
			WHEN C =>
					EVOUT				<= EVC;
					STROBEOUT			<= NOT EMPTY3;
					ACKFIFO2			<= '0';
					ACKFIFO3			<= NOT EMPTY3;
			WHEN D =>
					EVOUT				<= EVD;
					STROBEOUT			<= NOT EMPTY4;
					ACKFIFO3			<= '0';
					ACKFIFO4			<= NOT EMPTY4;
			WHEN E =>
					EVOUT				<= EVE;
					STROBEOUT			<= NOT EMPTY5;
					ACKFIFO4			<= '0';
					ACKFIFO5			<= NOT EMPTY5;
			WHEN F =>
					EVOUT				<= EVF;
					STROBEOUT			<= NOT EMPTY6;
					ACKFIFO5			<= '0';
					ACKFIFO6			<= NOT EMPTY6;
					
			WHEN OTHERS =>
					STROBEOUT			<= '0';
					ACKFIFO6			<= '0';
		END CASE;
	END PROCESS;
					
					
			
END EVMPX_architecture;
