/***************************************************************************/
/*                                                                         */
/*        --- CAEN Engineering Srl - Computing Systems Division ---        */
/*                                                                         */
/*    A303.C                                                			         */
/*                                                                         */
/*    Hides Operating System dependent implementation of generic routines  */
/*    to drive the A303/A module                                           */
/*                                                                         */
/*    Source code written in Microsoft Visual C++                          */
/*                                                                         */
/*    This is the Win32 implementation                                     */
/*    It needs a303lib.dll installed                                       */
/*                                                                         */
/*    Created: January 2000                                                */
/*                                                                         */
/***************************************************************************/
#include <wtypes.h>
#include <stdio.h>
#include "a303.h"

typedef __declspec(dllimport) int (* A303SENDCOMMAND)(int, int, unsigned char *, int);
typedef __declspec(dllimport) int (* A303READRESPONSE)(unsigned char *, int *);
typedef __declspec(dllimport) int (* A303RESET)(void);
typedef __declspec(dllimport) int (* A303INIT)(unsigned long);
typedef __declspec(dllimport) int (* A303TIMEOUT)(unsigned long);

#define LIB_NAME "a303lib.dll"

#define TUTTOK             0
#define E_OS               1
#define E_LESS_DATA        2
#define E_TIMEOUT          3
#define E_NO_A303          4
#define E_A303_BUSY        5

static HINSTANCE		    hDLL;               // Handle to DLL
static A303SENDCOMMAND	A303libSendCommand;
static A303READRESPONSE	A303libReadResponse;
static A303RESET		    A303libReset;
static A303INIT			    A303libInit;
static A303TIMEOUT		  A303libTimeout;

/***------------------------------------------------------------------------

  A303Init

    --------------------------------------------------------------------***/
int A303Init(unsigned long Address)
{
	hDLL = LoadLibrary(LIB_NAME);

	if (hDLL != NULL)
	{
		A303libSendCommand = (A303SENDCOMMAND)GetProcAddress(hDLL, "A303SendCommand");
		A303libReadResponse = (A303READRESPONSE)GetProcAddress(hDLL, "A303ReadResponse");
		A303libReset = (A303RESET)GetProcAddress(hDLL, "A303Reset");
		A303libInit = (A303INIT)GetProcAddress(hDLL, "A303Init");
		A303libTimeout = (A303TIMEOUT)GetProcAddress(hDLL, "A303Timeout");

		if( !A303SendCommand || !A303ReadResponse || !A303Reset ||
        !A303Init        || !A303Timeout )
		{
			FreeLibrary(hDLL);       
			return E_OS;
		}
		else
		{
			return A303libInit(Address);
		}
	}
	return E_OS;
}

/***------------------------------------------------------------------------

  A303SendCommand

    --------------------------------------------------------------------***/
int A303SendCommand(int code, int crnum, void *buf, int count)
{
	return A303libSendCommand(code, crnum, (unsigned char *)buf, count);
}

/***------------------------------------------------------------------------

  A303ReadResponse

    --------------------------------------------------------------------***/
int A303ReadResponse(void *buf, int *count)
{
	return A303libReadResponse((unsigned char *)buf, count);
}

/***------------------------------------------------------------------------

  A303Reset

    --------------------------------------------------------------------***/
int A303Reset(void)
{
	return A303libReset();
}

/***------------------------------------------------------------------------

  A303Timeout

    --------------------------------------------------------------------***/
int A303Timeout(unsigned long Timeout)
{
	return A303libTimeout(Timeout);
}

/***------------------------------------------------------------------------

  A303End

    --------------------------------------------------------------------***/
int A303End(void)
{
	FreeLibrary(hDLL);
	return 0;
}

/***------------------------------------------------------------------------

  A303DecodeResp

    --------------------------------------------------------------------***/
char *A303DecodeResp(int resp)
{
  static char buf[80];

  if( resp == E_OS )
    sprintf(buf, "Operating System Error: %d", GetLastError());
  else
    switch( resp )
      {
        case E_LESS_DATA:
          strcpy(buf, "CaeNet Error: Less data received" );
          break;
        case E_TIMEOUT:
          strcpy(buf, "CaeNet Error: Timeout expired" );
          break;
        case E_NO_A303:
          strcpy(buf, "CaeNet Error: A303 not found" );
          break;
        case E_A303_BUSY:
          sprintf(buf, "Another instance of %s already loaded", LIB_NAME );
          break;
        default:
          sprintf(buf, "CaeNet Error: %d", resp );
          break;
      }

  return buf;
}
